#!perl
# Joerg Meyer, 2005-10-31 .. 2011-08-11, 2014-06-18, 2016-10-28, 2017-05-29

$PROGRAM = 'analyzeCSV.pl';
$VERSION = '0.85';
$DESCRPT = 'Ermittelt Struktur einer Datei mit separierten Feldinhalten';

sub usage {
    print 'Usage: ', $PROGRAM, " [Parameter] [Datei]\n",
          $DESCRPT, "\n\n",
          "Parameter:\n",
          "\t-a\tAusfuehrliche Textmeldungen\n",
          "\t-d\tDOS-Zeilenenden <CRLF>\n",
          "\t-e\tAbbruch nach dem zehnten Fehler\n",
          "\t-h\tDiese Hilfe ausgeben\n",
          "\t-m\tZeilen aus nur Minuszeichen NICHT ueberspringen\n",
          "\t-q\tKeine Textmeldungen\n",
          "\t-s\t(zchn) Angabe Feldtrenner\n",
          "\t-t\tTitelzeile ist Zeile (n)\n",
          "\t-u\tUNIX-Zeilenenden <LF>\n",
          "\t-w\tWertestatistik ausgeben\n",
          "\t-v\tVersion anzeigen\n";
    exit;
}

if (@ARGV == 0) {
    die $PROGRAM, ": Keine Parameter und keine Datei angegeben!\n\n";
}

%Feldtrennername = ("\t" => 'Tabulator',
                    '\|' => 'Pipe-Symbol',
                    ';'  => 'Semikolon',
                    ':'  => 'Doppelpunkt',
                    ','  => 'Komma',
                    '\*' => 'Stern-Symbol',
                    '\+' => 'Plus-Zeichen',
                    '\.' => 'Punkt');

$DATEINAME = $STATNAME = $FELDTRENNER = '';
$TITELZEILE = 0;
$SKIPLINIEN = 1;
$FELDERMINDERZAHL = 3;
$FELDBEGRENZER = '"';
$MITBEGRENZER = $ZAEHLEWERTE = $BREAKONERROR = 0;
$Ausfuehrl = $QUIET = $NextParmTitel = $NextParmTrenner = 0;

foreach (@ARGV) {
    if (substr($_, 0, 1) eq '-') {
        m/a/ && ($Ausfuehrl = 1);
        m/d/ && ($/ = "\r\n");
        m/e/ && ($BREAKONERROR = 1);
        m/h/ && &usage;
        m/m/ && ($SKIPLINIEN = 0);
        m/q/ && ($QUIET = 1);
        m/s/ && ($NextParmTrenner = 1);
        m/t/ && ($NextParmTitel = 1);
        m/u/ && ($/ = "\n");
        m/w/ && ($ZAEHLEWERTE = 1);
        m/v/ && die $PROGRAM, ' -- ', $VERSION, "\n";
    }
    else {
        if ($NextParmTrenner) {
            $FELDTRENNER = $_;
            $NextParmTrenner= 0;
        }
        elsif ($NextParmTitel) {
            die "Anzahl Titelzeilen '$_' nicht lesbar\n" unless m/\d+/;
            $TITELZEILE = $_;
            $NextParmTitel= 0;
        }
        elsif ($DATEINAME eq '') {
            $DATEINAME = $_;
        }
        else {
            print "Bitte nur einen Dateinamen angeben!\n";
        }
    }
}

print $DESCRPT, "\n" unless $QUIET;

$FELDTRENNER = "\t" if $FELDTRENNER eq 'tab';
$FELDTRENNER = "\n" if $FELDTRENNER eq '\n';
$FELDTRENNER = '\|' if $FELDTRENNER eq '|';
$FELDTRENNER = '\*' if $FELDTRENNER eq '*';
$FELDTRENNER = '\+' if $FELDTRENNER eq '+';
$FELDTRENNER = '\.' if $FELDTRENNER eq '.';
$FELDTRENNER = '\?' if $FELDTRENNER eq '?';

if ($DATEINAME eq '') {
    print "-- Lese von Standard-Input\n" unless $QUIET;
    open(INP, '-');  # STDIN
    $DATEINAME = $PROGRAM;
}
else {
    print '-- Lese Datei ', $DATEINAME, "\n" unless $QUIET;
    open(INP, '<' . $DATEINAME) || die "$DATEINAME ... geht nicht auf!\n";
}

if ($ZAEHLEWERTE) {
    $STATNAME = 'stat_' . $DATEINAME;
    print '-- Schreibe Statistik in Datei ', $STATNAME, "\n" unless $QUIET;
}

@feldnamen  = ();
@feldtyp    = ();
@feldbreite = ();
@feldmlen   = ();
@feldmax    = ();
@feldmin    = ();
@feldleer   = ();
@feldval    = ();
@feldkomm   = ();
$feldanzahl = 0;

$zeilen = $datenzeilen = $fehler = 0;

if ($TITELZEILE) {
    print "-- Titel sind in Zeile ", $TITELZEILE, "\n" unless $QUIET;
    $t = <INP> for (1 .. $TITELZEILE);
    chomp $t;

    print "\t'", $t, "'\n" if $Ausfuehrl and ($TITELZEILE > 1);

    if ($FELDTRENNER eq '') {
        foreach $ftr (keys %Feldtrennername) {
            if ($t =~ m/$ftr/) {
                $FELDTRENNER = $ftr;
                last;
            }
        }
    }

    @feldnamen = split($FELDTRENNER, $t);
    foreach (@feldnamen) { s/\s+$//; }
    foreach (@feldnamen) { push @feldtyp, '-'; }
    $FELDANZAHL = scalar @feldnamen;

    print '   Titeleile besteht aus ', $FELDANZAHL, " Feldern.\n"
        if $Ausfuehrl;
}
else {
    print "-- Keine Titelzeile\n" unless $QUIET;
}

die "Kein Feldtrenner erkennbar oder angegeben!\n" if $FELDTRENNER eq '';
print '-- Feldtrenner ist ', $Feldtrennername{$FELDTRENNER}, "\n" unless $QUIET;

while (<INP>) {
    chomp;
    $zeilen++;

    if (/^\s*$/) {
        print '-- Zeile ', $zeilen, " ist leer.\n" unless $QUIET;
        next;
    }

    next if $SKIPLINIEN and m/^\s*-+$/;

    $datenzeilen++;

    @daten = split($FELDTRENNER, $_);

    if ($feldanzahl - $FELDERMINDERZAHL > scalar @daten and not $QUIET) {
        print '-- Zeile ', $zeilen, ' hat nur ', 
            1 + scalar @daten, ' Feld(er), anstatt ', $feldanzahl, "\n";
        $fehler++;
    }

    $feldanzahl = $#daten + 1 if $feldanzahl <= $#daten;

    $feld = 0;
    foreach (@daten) {
        if (not defined $feldnamen[$feld]) {
            $feldnamen[$feld] = 'Feld_' . ($feld+1);
            $feldkomm[$feld] = 'Zl. ' . $zeilen . ': Neues Feld'
                unless ($TITELZEILE == 0) && ($zeilen == 1);
            $feldtyp[$feld] = '-';
            $fehler++;
            print '-- Zeile ', $zeilen, ' hat ', 1 + scalar @daten, ' Felder oder ',
                  "Feldtrenner in einem Datenfeld\n"
                if $BREAKONERROR;
        }

        $feldbreite[$feld] = length($_) if length($_) > $feldbreite[$feld];

        if (substr($_, 0, 1) eq $FELDBEGRENZER and
            substr($_, -1, 1) eq $FELDBEGRENZER) {

            if (! $MITBEGRENZER) {
                $MITBEGRENZER = 1;
                print '-- Datei enthaelt Feldbegrenzer ab Zeile ', $zeilen, "\n"
                    unless $QUIET;
            }

            $_ = substr($_, 1, -1);

#           (m/$FELDBEGRENZER/) &&
#               ($feldkomm[$feld] = 'Zl. ' . $zeilen . ': Feldbegr. im Feld!');
        }

        s/^\s+//;
        s/\s+$//;
        $aktTyp = $_ eq '' ? '-' : '?';
        $aktTyp = 'Z' if m/^\d\d:\d\d:\d\d,?\d*$/;
        $aktTyp = 'R' if m/^-?[0-9.,]+$/;
        $aktTyp = 'D' if m/^\d{1,4}([.\/\-])\d\d?\1\d{1,4}$/;
        $aktTyp = 'I' if m/^-?\d+$/;
        $aktTyp = 'L' if m/^-?\d{10,}$/;
        $aktTyp = 'T' if m/[A-Za-z]/;

        if ($feldtyp[$feld] eq 'I' or
            $feldtyp[$feld] eq 'R' or
            $feldtyp[$feld] eq 'L') {

            if ($aktTyp eq 'R') {
                $feldtyp[$feld] = 'R';
            }

            if ($aktTyp eq 'T' or
                $aktTyp eq 'D') {

                $feldtyp[$feld] = 'T';
                $feldkomm[$feld] = 'Zl. ' . ($zeilen + $TITELZEILE) . ': '.
                                   substr($daten[$feld], 0, 10);
            }
        }
        elsif ($feldtyp[$feld] eq 'T' or
               $feldtyp[$feld] eq 'D') {
            # nix
        }
        else {

            $feldkomm[$feld] = 'Ab Zl. ' . ($zeilen + $TITELZEILE)
                if $feldtyp[$feld] eq '-' and
                   $aktTyp ne '-' and
                   $zeilen > 1;

            $feldtyp[$feld] = $aktTyp
                if $aktTyp ne '-' and $aktTyp ne $feldtyp[$feld];
        }

        $feldmlen[$feld] = length($_) if length($_) > $feldmlen[$feld];

        if ($ZAEHLEWERTE) {
            if ($_ eq '') {
                $feldleer[$feld]++;
            }
            else {
                if ($feldtyp[$feld] eq 'I' or
                       $feldtyp[$feld] eq 'R' or
                       $feldtyp[$feld] eq 'D') {

                    $_ = substr($_, 6, 4) . '-' .
                         substr($_, 3, 2) . '-' .
                         substr($_, 0, 2) if $feldtyp[$feld] eq 'D';

                    $feldmax[$feld] = $_ if $_ > $feldmax[$feld];

                    $feldmin[$feld] = $_ if $_ < $feldmin[$feld] or
                                            not defined $feldmin[$feld];
                }
                else {
                    $feldmax[$feld] = $_ if $_ gt $feldmax[$feld];

                    $feldmin[$feld] = $_ if $_ lt $feldmin[$feld] or
                                            not defined $feldmin[$feld];
                }
                $feldval[$feld]->{$_}++;
            }
        }
        $feld++;
    }
    last if $BREAKONERROR and ($fehler > 9);
}

close INP;

print "\n" unless $QUIET;

$FORMSTR = "%3s  %30s%2s%3s  %3s  %3s  %-24s\n";
printf $FORMSTR, 'Lfd', 'Feldname', '', 'Typ', 'Brt', 'Len', 'Hinweis';
$TRENNSTR = sprintf $FORMSTR, '---', '-' x 30, '', '---', '---', '---', '-' x 15;
print $TRENNSTR;

$feld = 0;
foreach (@feldnamen) {
    printf $FORMSTR,
           $feld + 1,
           substr($feldnamen[$feld], 0, 30),
           length($feldnamen[$feld]) > 30 ? '>>' : '  ',
           $feldtyp[$feld],
           $feldbreite[$feld] || '0',
           $feldmlen[$feld] || '-',
           substr($feldkomm[$feld], 0, 24);

    $feld++;
}

print $TRENNSTR;

if ($ZAEHLEWERTE) {

    open(OUT, '>' . $STATNAME) || die "$STATNAME ... geht nicht auf!\n";

    $FORMSTR = "%3s  %30s%2s%3s %4s  %3s %6s  %6s  %-24s  %6s%1s%7s  %-10s  %-24s\n";
    printf OUT $FORMSTR, 'Lfd', 'Feldname', '', 'Typ', 'Brt', 'Len', 'Inhalt', 'Leer',
                         'Wertebereich', 'WrtVor', '', 'HWrtAnz', 'HWrtInhalt', 'Hinweis';
    $TRENNSTR = sprintf $FORMSTR, '---', '-' x 30, '', '---', '---', '---', '------', '------',
                         '-' x 24, '------', '', '-------', '----------', '----------';
    print OUT $TRENNSTR;

    $feld = 0;
    foreach (@feldnamen) {

       $hwert_inh = '';
       $hwert_anz = 0;

       foreach (keys %{$feldval[$feld]}) {
           if ($feldval[$feld]->{$_} > $hwert_anz) {
               $hwert_inh = $_;
               $hwert_anz = $feldval[$feld]->{$_};
           }
       }

       printf OUT $FORMSTR,
           $feld + 1,
           substr($feldnamen[$feld], 0, 30),
           length($feldnamen[$feld]) > 30 ? '>>' : '  ',
           $feldtyp[$feld],
           $feldbreite[$feld] || '0',
           $feldmlen[$feld] || '-',

           $feldtyp[$feld] eq '-' ? '' : $datenzeilen - $feldleer[$feld],
           $feldtyp[$feld] eq '-' ? '' : $feldleer[$feld] || '0',
           $feldtyp[$feld] eq '-' ? '' : substr($feldmin[$feld], 0, 10) .
                                         ($feldtyp[$feld] eq 'I' ?
                                             ($feldmin[$feld] <  $feldmax[$feld] ? ' .. ' . substr($feldmax[$feld], 0, 10) : '') :
                                             ($feldmin[$feld] lt $feldmax[$feld] ? ' .. ' . substr($feldmax[$feld], 0, 10) : '')),

           $feldtyp[$feld] eq '-' ? '' : scalar keys %{$feldval[$feld]},
           scalar keys %{$feldval[$feld]} == $datenzeilen ? '!' : ' ',
           $feldtyp[$feld] eq '-' ? '' : $hwert_anz,
           $hwert_anz == 1 ? '' : substr($hwert_inh, 0, 10),

           substr($feldkomm[$feld], 0, 24);

        $feld++;
    }
    print OUT $TRENNSTR;
    print OUT 'Fertig nach ', $datenzeilen, ' Datenzeilen in ', 
        $TITELZEILE+$zeilen, " Dateizeilen.\n";

    close OUT;
}

if ($BREAKONERROR and ($fehler > 9)) {
    print "\nAbbruch nach ", $fehler, " Fehler.\n" unless $QUIET;
}
else {
    print "\nFertig nach ", $datenzeilen, ' Datenzeilen in ', 
        $TITELZEILE+$zeilen, " Dateizeilen.\n" unless $QUIET;
}
