#!perl -w
# My 2005-12-26

use Net::NNTP;

$PROGRAM = 'getnews';
$VERSION = 'V0.43';
$MAXMSGPERGRP = 200;
$CFGEXT = '.cfg';
$DATEXT = '.dat';
$LOGEXT = '.log';
$Logging = 1;

print $PROGRAM, " -- Newsserver auslesen.\n";

$NewsServer = $Username = $Password = '';
$NewsPort = 119;
%NewsGroups = ();

sub FormatDatum {
    my $t = shift;
    return '(unbekannt)' if $t < 1000;

    ($sek, $min, $std, $tag, $mon, $jhr) = (localtime $t)[0..5];
    return sprintf "%d-%.2d-%.2d %.2d:%.2d:%.2d",
           1900+$jhr, $mon+1, $tag, $std, $min, $sek;
}

sub LogMsg {
    return unless $Logging;

    my $t = shift;

    open LOG, '>>' . $PROGRAM . $LOGEXT;
    print LOG &FormatDatum(time), ' ', $t, "\n";
    close LOG;
}

sub LeseZeitstempel {

    print 'Lese Zeitstempel ', $DatFile;

    if (open DAT, '<' . $DatFile) {
        print " ein...\n";
        my $ln = 0;

        while (<DAT>) {
            chomp;
            $ln++;
            next if /^\s*$/;

            if (/^#/) {
                # Nur ein Kommentar
            }
            elsif (/:/) {
                ($name, $datime) = ($`, $');

                $NewsGroups{$name} = $datime;
            }
            else {
                print 'Konfigurationszeile ', $ln, " nicht erkannt.\n";
            }
        }
        close DAT;
    }
    else {
        print " nicht gefunden.\n";
    }
}

sub SchreibeZeitstempel {

    open DAT, '>' . $DatFile;
    print DAT "# Getnews Timestamp-Store\n";

    foreach (sort keys %NewsGroups) {
        print DAT $_, ':', $NewsGroups{$_}, "\n";
    }

    close DAT;
}

sub GetNewsGroup {
    my $ng = shift;

    die "Kein Newsserver angegeben!\n" if length($NewsServer) < 10;
    die "Kein Dateiname angegeben!\n" if length($Filename) < 3;

    ($anzahl, undef, undef, $gruppe) = $server->group($ng);

    if (! $gruppe) {
        print 'Gruppe ', $ng, " nicht gefunden!\n";
        &LogMsg($ng. " nicht gefunden.\n");
        next;
    }

    print 'Gruppe ', $gruppe, ' enthaelt ', $anzahl, " Artikel.\n";

    &LogMsg($gruppe. ': '. $anzahl. ' Artikel gesamt.');

    $timestamp = $NewsGroups{$ng};
    $msglistref = $server->newnews($timestamp, $ng);

    print "\t", scalar(@$msglistref),
                ' Artikel sind neuer als ', &FormatDatum($timestamp), ".\n";

    &LogMsg($gruppe. ': '. scalar(@$msglistref).
            ' Artikel neuer als '. &FormatDatum($timestamp). '.');

    $NewsGroups{$ng} = $server->date();

    while (scalar(@$msglistref) > $MaxMsg) {
        shift @$msglistref;
    }

    open LST, '>>' . $Filename;

    foreach (@$msglistref) {
        $articleref = $server->article($_) || next;

        print LST "From - Mon Jan 1 00:00:00 2003\n",
              @$articleref,
              "\n";
    }

    close LST;

    &LogMsg($gruppe. ': '. scalar(@$msglistref). ' Artikel abgeholt.');

    &SchreibeZeitstempel;

}

($tag, $mon, $jhr, $wtg) = (localtime)[3..6];

$tag = '0' . $tag if $tag < 10;
$mon++;
$mon = '0' . $mon if $mon < 10;
$jhr += 1900;
$wtg = ('So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa')[$wtg];

$CfgFile = ($#ARGV > -1) ? $ARGV[0] : ($PROGRAM . $CFGEXT);
$DatFile = $PROGRAM . $DATEXT;

&LeseZeitstempel();

$MaxMsg = $MAXMSGPERGRP;

print 'Lese Konfiguration ', $CfgFile;

if (open CFG, '<' . $CfgFile) {
    print ".\n";

    my $ln = 0;

    while (<CFG>) {
        $ln++;
        chomp;
        next if /^\s*$/;

        if (/^#/) {
           # Nur ein Kommentar
        }
        elsif (/=/) {
           ($var, $value) = (lc($`), $');

           if ($var eq 'feed') {
               $NewsServer = $value;

               if (defined $server) {
                   $server->quit;
                   &LogMsg('Verbindung geschlossen.');
                   undef $server;
               }

               ($NewsServer =~ /:/) && (($NewsServer, $NewsPort) = ($`, $'));

               print "\nStelle Verbindung zu ", $NewsServer,
                                  ' auf Port ', $NewsPort, " her...\n";

               $server = Net::NNTP->new($NewsServer,
                                        Port => $NewsPort,
                                        Timeout => 30) || die $|;

               &LogMsg('-' x 55);
               &LogMsg('Verbindung zu '. $NewsServer. ' hergestellt.');
           }

           elsif ($var eq 'user') {
               ($Username, $Password) = ($value =~ /(.*):(.*)/);

               if ($server->authinfo($Username, $Password)) {
                   print "Anmeldung erfolgreich\n";
               }
               else {
                   die "Anmeldung fehlgeschlagen!";
               }

           } elsif ($var eq 'maxmsgpergrp') {
              $MaxMsg = $value;

              &LogMsg('Maximal '. $MaxMsg. ' Msg/Grp abholen.');

           } elsif ($var eq 'logging') {
              $Logging = $value;

           } elsif ($var eq 'filename') {
              $Filename = $value;

              $Filename =~ s/%t/$tag/;
              $Filename =~ s/%m/$mon/;
              $Filename =~ s/%j/$jhr/;

              print 'Datei ist: ', $Filename, "\n";
              die "Datei ist bereits vorhanden.\n" if -e $Filename;

           } else {

               die 'Variable >', uc $var, '< ',
                   'in Zeile ', $ln, " nicht erkannt!\n";
           }
        }
        else {
           &GetNewsGroup($_);
        }
    }
    close LST;
}
else {
    print " nicht gefunden.\n";
}

$server->quit;

&LogMsg('Fertig.');

print "Fertig.\n";

