#!perl
# newsbase.pl
# Joerg Meyer, 2003-01-02 .. 2012-06-16, 2012-12-27

$PROGRAM = 'newsbase.pl';
$VERSION = 'v1.65';
$DESCRPT = 'News-Dateien in HTML-Strukturen umwandeln.';
$TITLE   = 'NewsBase';

$INPUTFILES = '*';

$STORE_PATH = '';
$PATH_SEP = '/';
$THREAD_PREFIX = 'thrd';
$GROUP_PREFIX = 'grp';
$FILE_EXT = '.html';

$FARBE_LISTE = '#EEEEEE';
$FARBE_KONTR = '#EEFFEE';
$FARBE_KNOPF = '#4040F0';
# $FARBE_KOPFZ = '#B8C0D4';
$FARBE_KOPFZ = '#A0E0F0';
$FARBE_PANEL = '#FFD070';
$FARBE_URLNK = '#FFBBBB';

$SPECMODE = 0;
$RUECKBUT = 0;

$MAX_COMMENT = 8;
$NO_MAX_COMMENT= '';
$DAT_NICHT_SCHREIBEN = 0;
$LINK_TO_CHAPTERS = 1;
$LONG_LINE = 50;
$LONG_NAME = 25;

$FONT_SIZE_LRG = 120;
$FONT_SIZE_MID = 100;
$FONT_SIZE_SML =  80;

@Cmds = ();
@MsgStore = ();
@ThreadStore = ();
%IdStore = ();
%MsgCount = ();
%OldNewsFiles = ();

%MonNr = ('Jan' => '01', 'Feb' => '02', 'Mar' => '03', 'Apr' => '04',
          'May' => '05', 'Jun' => '06', 'Jul' => '07', 'Aug' => '08',
          'Sep' => '09', 'Oct' => '10', 'Nov' => '11', 'Dec' => '12');

sub frmint {
    my $n = shift;
    my $l = shift;

    return substr(1000000 + $n, 7 - $l, $l);
}

sub abbrev {
    my $n = shift;
    my $l = shift;

    $n =~ s/.moderated$//;
    $n =~ s/mathematik$/mathe/;

    $n =~ s/(\w)\w+\./$1./g;

    if (length($n) > $l) {
        $n = '...' . substr($n, -$l+1, $l-1);
    }

    return $n;
}

sub LeseKonfigDatei {

    if (open LST, '<' . lc($TITLE) . '.cfg') {
        print 'Konfiguration einlesen...';

        my $ln = 0;
        while (<LST>) {
            $ln++;
            chomp;
            next if /^\s*$/;

            if (/^#/) {
               # Skip comments
            }
            elsif (/=/) {
               ($var, $value) = (lc $`, $');

               if ($var eq 'cmd') {
                   $patternkat = ($value =~ m/^\^\w/) ? substr($value, 1, 1) : '*';

                   push @{$Cmds{$patternkat}}, $value;
                   next;
               }

               ($var eq 'inputfiles')  && ($INPUTFILES    = $value) && next;
               ($var eq 'storepath')   && ($STORE_PATH    = $value) && next;
               ($var eq 'pathsep')     && ($PATH_SEP      = $value) && next;
               ($var eq 'maxcomment')  && ($MAX_COMMENT   = $value) && next;
               ($var eq 'nomaxcomment') && ($NO_MAX_COMMENT   = $value) && next;
               ($var eq 'longline')    && ($LONG_LINE     = $value) && next;
               ($var eq 'dropline')    && (push @DropLines, $value) && next;
               ($var eq 'dropsubj')    && (push @DropSubj,  $value) && next;

               die 'Variable >', uc $var, '< ',
                   'in Zeile ', $ln, " nicht erkannt!\n";
            }
            else {
                print 'Zeile ', $ln, " ungueltig!\n";
            }
        }
        close LST;
        print "\n";
    }
}

sub LeseGruppenliste {

    if (open LST, '<getnews.cfg') {
        print 'Gruppen einlesen...';

        while (<LST>) {
            chomp;
            next if /^$/;
            next if /^#/;
            next if /=/;

            push @KnownGroups, $_;
        }
        close LST;
        print "\n";
    }
}

sub LeseDateiListe {
    print "Alle Dateien gemaess Muster '", $INPUTFILES, "' einlesen.\n";

    opendir DIR, '.';
    push @dateien, sort grep(/$INPUTFILES/, readdir DIR);
    close DIR;
}

sub LeseAlteDateinamen {

    print 'Lese Namen alter Dateien...';

    if (open DAT, '<' . lc($TITLE) . '.dat') {

        while (<DAT>) {
            chomp;
            next if /^\s*$/;

            if (/^#/) {
                # Nur ein Kommentar
            }
            else {
                $OldNewsFiles{$_} = 1;
            }
        }
        close DAT;
        print "\n";
    }
    else {
        print " nicht gefunden.\n";
    }
}

sub SchreibeAlteDateinamen {

    open DAT, '>' . lc($TITLE) . '.dat';
    print DAT "# NewsBase Namen alter Dateien\n";

    foreach (@dateien) {
        print DAT $_, "\n";
    }

    close DAT;
}


sub StoreIndexFile {

    open LST, '>' . $STORE_PATH . $PATH_SEP . $GROUP_PREFIX . '000' . $FILE_EXT;

    print LST "<HTML>\n",
              "<HEAD>\n",
              '<TITLE>', $TITLE, "</TITLE>\n",
              $CSS_STYLE,
              "</HEAD>\n",
              "<BODY BGCOLOR=White>\n",
              "<FONT FACE=Verdana,Arial>\n",

              $SPECMODE == 2 ?
                  '<H2>'. $TITLE. "</H2>\n" :
                  '',

              $RUECKBUT ?
                  '<TABLE BORDER=0><TR><TD BACKGROUND=keiltast.png>'.
                      '<A HREF="../index.html"><FONT SIZE=2 COLOR=white><B>Zur&uuml;ck zur Auswahlseite</B></FONT></A>'.
                      '</TD></TR></TABLE>' :
                  '',

              $SPECMODE ?
                  "<TABLE WIDTH=100% BORDER=0>\n".
                  '<TR CLASS=VerdLrg HEIGHT=40 BGCOLOR='. $FARBE_PANEL. '><TD><B>'. $TITLE. "</B></TD></TR>\n" :
#                 '<TR BGCOLOR='. $FARBE_KOPFZ. "><TH>Gruppe</TH><TH>Themen</TH><TH>Mittlg</TH></TR>\n" :

                  "<TABLE>\n".
                  '<TR><TD BGCOLOR='. $FARBE_KOPFZ. '><FONT FACE=Verdana SIZE=5><B>&nbsp;'. $TITLE. "&nbsp;</B></FONT></TD></TR>\n".
                  "</TABLE>\n".
                  "<HR>\n";

    my $i = 0;
    $out_msgs_ctr = 0;
    $out_thrd_ctr = 0;

    foreach (sort keys %MsgCount) {
        $i++;
        my $grp = $_;

        s/moderated/mod/;
        s/networking/netw/;
        s/wissenschaft/wiss/;
        s/mathematik/mathe/;

        if ($SPECMODE) {
            print LST '<TR CLASS=VerdLrg BGCOLOR=', ($i & 1) ? $FARBE_LISTE : $FARBE_KONTR, '>',
                      '<TD><A HREF="', $GROUP_PREFIX, &frmint($i, 3), $FILE_EXT, '">',
                         $_, '</A><BR><SMALL>',
                      (scalar values %{$NewThreads{$grp}}), ' Themen mit ',
                      $MsgCount{$grp}, " Mitteilungen.</SMALL></TD></TR>\n";

 #          print LST '<TR CLASS=VerdLrg BGCOLOR=', ($i & 1) ? $FARBE_LISTE : $FARBE_KONTR, '>',
 #                    '<TD><A HREF="', $GROUP_PREFIX, &frmint($i, 3), $FILE_EXT, '">',
 #                       $_, '</A></TD>',
 #                    '<TD ALIGN=right>', (scalar values %{$NewThreads{$grp}}), '</TD>',
 #                    '<TD ALIGN=right>', $MsgCount{$grp}, '</TD>',
 #                    "</TR>\n";
         }
        else {
            print LST '<A HREF="', $GROUP_PREFIX, &frmint($i, 3), $FILE_EXT, '" ',
                         'TARGET=grp><B>', $_, '</B></A>',
                      '&nbsp;<SMALL>(', (scalar values %{$NewThreads{$grp}}), ' Themen, ',
                      $MsgCount{$grp}, " Mittlg)</SMALL><BR>\n";
        }

        $out_msgs_ctr += $MsgCount{$grp};
        $out_thrd_ctr += scalar values %{$NewThreads{$grp}};
    }

    (undef, $min, $std, $mtag, $mon, $jahr, undef, undef, $isdst) = localtime();
    $std++ if $isdst;

#    print LST '<TR BGCOLOR=', $FARBE_KOPFZ, '><TD ALIGN=center><B>Summe</B></TD>',
#                   '<TD ALIGN=right><B>', $out_thrd_ctr, '</B></TD>',
#                   '<TD ALIGN=right><B>', $out_msgs_ctr, '</B></TD>',
#              "</TR>\n"

     print LST '<TR HEIGHT=40 BGCOLOR=', $FARBE_PANEL, '><TD>Insgesamt ', $out_thrd_ctr, ' Themen mit ',
                                                                $out_msgs_ctr, " Mitteilungen.</TD></TR>\n"
        if $SPECMODE;

    print LST $SPECMODE ? "</TABLE>\n" : "<HR>\n",
              '<P><SMALL>', $PROGRAM, ' ', $VERSION, ', ',
                  substr(100+$mtag, 1, 2), '.', substr(101+$mon, 1, 2), '.', (1900+$jahr), ' ',
                  substr(100+$std, 1, 2), ':', substr(100+$min, 1, 2), "</SMALL></P>\n",
              "</FONT>\n",
              "</BODY>\n",
              "</HTML>\n";
    close LST;

    print "Index erzeugt.\n";
}

sub StoreGroupFile {
    my $grp = shift;
    my $i = shift;
    my $TitleSize = $SPECMODE ? '+2' : '+1';
       $TitleSize = '+0' if $SPECMODE eq 2;

    printf "Gruppe %-30s: %8d Mitteilungen\n", $grp, $MsgCount{$grp};

    $_ = $grp;

    if ($SPECMODE) {
        s/moderated/mod/;
        s/networking/netw/;
        s/wissenschaft/wiss/;
        s/mathematik/mathe/;
    }

    open LST, '>' . $STORE_PATH . $PATH_SEP . $GROUP_PREFIX . &frmint($i, 3) . $FILE_EXT;

    print LST "<HTML>\n",
              "<HEAD>\n",
#             '<TITLE>Grp ', &abbrev($grp, 15), "</TITLE>\n",
              '<TITLE>Grp: ', $grp, "</TITLE>\n",
              $CSS_STYLE,
              "</HEAD>\n",
              "<BODY BGCOLOR=White>\n",
              "<A NAME=top>\n",

              "<TABLE BORDER=0 WIDTH=100%>\n".
              '<TR CLASS=VerdLrg>',
                  $SPECMODE ?
                      '<TD ALIGN=CENTER BACKGROUND=keiltast.png WIDTH=110>'.
                      '&nbsp;<A HREF="'. $GROUP_PREFIX. '000'. $FILE_EXT. '">'.
                      '<FONT COLOR=white>Gruppen-<BR>auswahl</FONT></A></TD>'.
                      "<TD WIDTH=5>&nbsp;</TD>\n" :
                      '',

                  '<TD BGCOLOR=', $FARBE_PANEL, '><B>&nbsp;', $_, '</B></TD>',
              "</TR>\n",
              "</TABLE>\n",

              "<TABLE WIDTH=100% BORDER=0 CLASS=VerdMid>\n";

    $i = 0;
    foreach my $thrd (@{$$ThreadStore{$grp}}) {
        $i++;

        my @msgs = @{$$ThreadMsgs{$grp}->{$thrd}};
        my $AnzMsgs = @msgs;
        my $fMsgId = $msgs[0];
        my $lMsgId = $msgs[$AnzMsgs-1];
        my $thrnew = $NewThreads{$grp}->{$thrd};

        my $thrlen = 0;
        foreach my $j (0 .. $AnzMsgs-1) {
            $thrlen += $MsgStore[$msgs[$j]]->{'Cnt'};
        }

        my $dattxt = '';
        my $vondat = substr($MsgStore[$fMsgId]->{'Date'}, 0, 6);

        if ($AnzMsgs == 1) {
            $dattxt = $MsgStore[$fMsgId]->{'From'} . ' am ' . $vondat;
        }
        else {
            my $bisdat = substr($MsgStore[$lMsgId]->{'Date'}, 0, 6);
            $dattxt = ($thrnew < $AnzMsgs ? $thrnew . ' von ' : '') .
                      $AnzMsgs . ' Mittlg. ';

            if ($vondat eq $bisdat) {
                $dattxt .= 'am '. $vondat;
            }
            else {
                $dattxt .= 'vom '. $vondat. ' bis '. $bisdat;
            }
        }

        print LST '<TR CLASS=VerdLrg BGCOLOR=', ($i & 1) ? $FARBE_LISTE : $FARBE_KONTR, '>',
                  '<TD><A NAME=', &frmint($fMsgId, 4), ' ',
                  'HREF="', $THREAD_PREFIX, &frmint($fMsgId, 4), $FILE_EXT, '"',

                  $SPECMODE ? '' : ' TARGET=msg',

                  '>',

                  $SPECMODE ? '' : '<B>',

                  $MsgStore[$fMsgId]->{'Subj'},

                  $SPECMODE ? '' : '</B>',

                  "</A><BR>\n",

                  '<SMALL>-&nbsp;', $dattxt, ' mit ', $thrlen, " Zln.</SMALL></TD>\n"
            if $thrlen;
    }

    print LST "</TABLE>\n",
              '<TABLE WIDTH=100% BORDER=0>',
              '<TR CLASS=VerdLrg>',
                  $SPECMODE ?
                      '<TD WIDTH=110 BACKGROUND=keiltast.png ALIGN=center>' .
                          '<A HREF="'. $GROUP_PREFIX. '000'. $FILE_EXT. '">' .
                          '<FONT COLOR=white>Gruppen-<BR>auswahl</FONT></A></TD>' .
                          "<TD WIDTH=5>&nbsp;</TD>\n" :
                      '',

                  '<TD WIDTH=90 BACKGROUND=keiltast.png ALIGN=center><A HREF="#top">'.
                      "<FONT COLOR=white>Seiten-<BR>anfang</FONT></A></TD>\n",
                  '<TD WIDTH=5>&nbsp;</TD><TD BGCOLOR=', $FARBE_PANEL, ">&nbsp;</TD></TR>\n",
              "</TABLE>\n",

              "</BODY>\n",
              "</HTML>\n";
    close LST;
}

sub StoreThreadFile {
    my $thr = shift;
    my $grp = shift;
    my $gnr = shift;
    my @msgs = @{$$ThreadMsgs{$grp}->{$thr}};
    my $thrnew = $NewThreads{$grp}->{$thr};

    my $AnzMsgs = @msgs;
    my $TitleSize = '+1';

    open(MSG, '>' . $STORE_PATH . $PATH_SEP .
                    $THREAD_PREFIX . &frmint($msgs[0], 4) . $FILE_EXT) ||
        die 'Kann Mitteilung '. $STORE_PATH . $PATH_SEP .
                                $THREAD_PREFIX . &frmint($msgs[0], 4) . $FILE_EXT. " nicht ablegen.\n";

    print MSG "<HTML>\n",
              "<HEAD>\n",
#             '<TITLE>', &abbrev($grp, 15), '-Mtlg ', $msgs[0], ': ',
              '<TITLE>', $grp, '-Mtlg: ', $MsgStore[$msgs[0]]->{'Subj'},
              "</TITLE>\n",
              $CSS_STYLE,
              "</HEAD>\n",
              "<BODY BGCOLOR=white><A NAME=top></A>\n";

    if ($AnzMsgs > 1) {

        $LastDepth = 0;
        @LastMsgId = ($MsgStore[$msgs[0]]->{'Id'});
        @LastIdChain = ();
        @{$LastIdChain[0]} = @LastMsgId;

        my $i = 1;
        while ($i <= $AnzMsgs - 1) {
            my $depth = $MsgStore[$msgs[$i]]->{'Dep'};

            if ($depth > 0 && $LastMsgId[$depth-1] ne $MsgStore[$msgs[$i]]->{'Ref'}) {
                my $RefId = $MsgStore[$msgs[$i]]->{'Ref'};

#               if ($depth-1 != $LastDepth && $LastMsgId[$LastDepth] eq $RefI) {
#                   $depth = $LastDepth+1;
#                   $MsgStore[$msgs[$i]]->{'Dep'} = $depth;
#                   print '!!!';
#               }
#               else {
                    my $j = $i-1;
                    $j-- while $j > 0 && $LastIdChain[$j]->[$depth-1] ne $RefId;

                    if ($LastIdChain[$j]->[$depth-1] eq $RefId) {
                        my $m = splice(@msgs, $i, 1);
                        splice(@msgs, $j+1, 0, $m);

                        $i = 0;
                        $depth = 0;
                        @LastMsgId = ($MsgStore[$msgs[0]]->{'Id'});
                        @LastIdChain = ();
                    }
#               }
            }

            if ($i > 0) {
                $LastMsgId[$depth] = $MsgStore[$msgs[$i]]->{'Id'};
            }

            $LastDepth = $depth;
            splice(@LastMsgId, $depth + 1);
            @{$LastIdChain[$i]} = @LastMsgId;
            $i++;
        }

        print MSG '<TABLE WIDTH=100% BORDER=0 BGCOLOR=', $FARBE_PANEL, ">\n",
                  "<TR><TD>\n",
                  "<TABLE>\n",
                  '<TR CLASS=VerdLrg><TD COLSPAN=2><FONT SIZE=+2><B><A HREF="#sec', $msgs[0], '">',
                          $MsgStore[$msgs[0]]->{'Subj'}, "</B></A></FONT></TD></TR>\n",

                  '<TR CLASS=VerdSml><TD WIDTH=100>Gruppe:</TD>',
                      '<TD><B>',
                          $SPECMODE ?
                              '<A HREF="grp'. &frmint($gnr, 3). '.html'.
                              ($LINK_TO_CHAPTERS ? '#'. &frmint($msgs[0], 4) : '') .
                              '">' :
                              '',
                          $grp,
                          $SPECMODE ? '</A>' : '',
                          "</B></TD></TR>\n",

                  '<TR CLASS=VerdSml><TD>Anzahl:</TD>',
                      '<TD><B>', $thrnew < $AnzMsgs ? $thrnew . ' von ' : '', $AnzMsgs, " Mitteilungen</B></TD></TR>\n",

                  "</TABLE>\n",
                  "</TD><TD ALIGN=right>\n",
                  "<TABLE CLASS=VerdLrg CELLSPACING=10>\n",
		  '<TR><TD WIDTH=110 ALIGN=center BACKGROUND=keiltast.png>',
                  '<A HREF="', $Nachfolger{$thr}, '"><FONT COLOR=white>N&auml;chstes<BR>Thema</FONT></A></TD></TR>', "\n",
		  '<TR><TD ALIGN=center BACKGROUND=keiltast.png>',
                  '<A HREF="#sec', $msgs[$0], '"><FONT COLOR=white>Erste<BR>Nachricht</FONT></A></TD></TR>', "\n",
                  "</TABLE>\n",
		  "</TD></TR>\n",
 		  "</TABLE>\n",
                  "<TABLE CLASS=VerdMid WIDTH=100% BORDER=0>\n";

        @LastMsgId = ();
        foreach $i (0 .. $AnzMsgs-1) {
            my $depth = $MsgStore[$msgs[$i]]->{'Dep'};
            my $refsign = ($LastMsgId[$depth-1] eq $MsgStore[$msgs[$i]]->{'Ref'}) ? '<IMG SRC=pfeil.gif>' : 'o ';
            my $sender = $MsgStore[$msgs[$i]]->{'From'};
            my $new_item = $MsgStore[$msgs[$i]]->{'New'};

            if ($SPECMODE && length($sender) > $LONG_NAME) {
                $sender = substr($sender, 0, $LONG_NAME-2) . '...';
            }

            if ($depth == 0) {
                $depstr = '';
            }
            elsif ($depth == 1) {
                $depstr = $refsign;
            }
            else {
                $depstr = '<IMG SRC=spacer.gif HEIGHT=1 WIDTH=' . 20*($depth-1) . '>' . $refsign;
            }

            print MSG '<TR BGCOLOR=', ($i & 1) ? $FARBE_LISTE : $FARBE_KONTR, '>',
                          '<TD><B>', $depstr, '</B>',
                          $new_item ? '<A HREF="#sec'. $msgs[$i]. '"><B>'. $sender. '</B></A>' :
                                      '<I>'. $sender. '</I>',
                          '</TD>',
                          '<TD ALIGN=right>', substr($MsgStore[$msgs[$i]]->{'Date'}, 0, 6), '</TD>',
                          '<TD ALIGN=right>', $MsgStore[$msgs[$i]]->{$new_item ? 'Cnt' : 'Len'}, ' Zln</TD>',
                      "</TR>\n";

            $LastMsgId[$depth] = $MsgStore[$msgs[$i]]->{'Id'};
        }

        print MSG "</TABLE><P>&nbsp;</P>\n";
    }

    foreach $i (0 .. $AnzMsgs-1) {

        if ($MsgStore[$msgs[$i]]->{'New'}) {

            print MSG '<A NAME="sec', $msgs[$i], '"></A>', "\n",
#                     '<TABLE WIDTH=100% BORDER=0 BGCOLOR=', $FARBE_KOPFZ, ">\n",
                      "<TABLE WIDTH=100% BORDER=0 BACKGROUND=keilkopf.png>\n",
                      "<TR><TD>\n",
                      "<TABLE>\n",

                      '<TR CLASS=VerdLrg><TD COLSPAN=2><B>',
                      ($i < $AnzMsgs-1) ? '<A HREF="#sec'. $msgs[$i+1] . '">' : '',
                      $MsgStore[$msgs[$i]]->{'Subj'},
                      ($i < $AnzMsgs-1) ? '</A>' : '',
                      "</B></TD></TR>\n",

                      '<TR CLASS=VerdSml><TD WIDTH=100>Von:</TD><TD><B>',
                      ($AnzMsgs > 1) ? '<A HREF="#top">' : '',
                      $MsgStore[$msgs[$i]]->{'From'}, ' ', $MsgStore[$msgs[$i]]->{'Domn'},
                      ($AnzMsgs > 1) ? '</A>' : '',
                      "</B></TD></TR>\n",

                      '<TR CLASS=VerdSml><TD>Datum:</TD><TD><B>', $MsgStore[$msgs[$i]]->{'Date'}, "</B></TD></TR>\n",

                      '<TR CLASS=VerdSml><TD>Gruppe:</TD><TD><B>',
                          $SPECMODE ?
                              '<A HREF="grp'. &frmint($gnr, 3). '.html'.
                              ($LINK_TO_CHAPTERS ? '#'. &frmint($msgs[0], 4) : '') .
                              '">'
                              : '',
                          $grp,
                          $SPECMODE ? '</A>' : '',
                          "</B></TD></TR>\n",

                      '<TR CLASS=VerdSml><TD>L&auml;nge:</TD><TD><B>', $MsgStore[$msgs[$i]]->{'Cnt'},
#                         ' von ', $MsgStore[$msgs[$i]]->{'Len'},
                          "</B></TD></TR>\n",

                      # 3. Spalte einfuehren und hier Position wie: 1.3.2 zeigen

                      "</TABLE>\n",
                      "</TD><TD ALIGN=right>\n",
                      "<TABLE CLASS=VerdLrg CELLSPACING=10>\n",
                      '<TR><TD WIDTH=90 ALIGN=center BACKGROUND=keiltast.png>',
                      '<A HREF="#top"><FONT COLOR=white>Seiten-<BR>anfang</FONT></A></TD>', "\n",
                      '<TD ALIGN=center BACKGROUND=keiltast.png>',
                      '<A HREF="', $Nachfolger{$thr}, '"><FONT COLOR=white>N&auml;chstes<BR>Thema</FONT></A></TD></TR>', "\n",
                      '<TR><TD ALIGN=center BACKGROUND=keiltast.png>',
                      '<A HREF="#bottom"><FONT COLOR=white>Seiten-<BR>ende</FONT></A></TD>', "\n",
                      '<TD WIDTH=110 BACKGROUND=keiltast.png ALIGN=center>',

                      ($i < $AnzMsgs-1) ? '<A HREF="#sec'. $msgs[$i+1] . '"><FONT COLOR=white>N&auml;chste<BR>Nachricht</FONT></A>' : '&nbsp;',

                      "</TD></TR>\n",
                      "</TABLE>\n",
                      "</TD></TR>\n",
                      "</TABLE>\n",
                      "<DIV CLASS=VerdMid><P>\n",

                      join("\n", @{$$MsgStore[$msgs[$i]]->{'MsgBody'}}), "\n",

                      "</DIV><P>&nbsp;</P>\n";
        }
    }

    print MSG "<TABLE WIDTH=100% CLASS=VerdLrg BORDER=0>\n",
              '<TR>',
                  $SPECMODE ?
                       '<TD WIDTH=110 ALIGN=center BACKGROUND=keiltast.png>'.
                           '<A NAME=bottom HREF="'. $GROUP_PREFIX . &frmint($gnr, 3). $FILE_EXT .
                           ($LINK_TO_CHAPTERS ? '#'. &frmint($msgs[0], 4) : '') .
                           '">'.
                           "<FONT COLOR=white>Mittlg-<BR>auswahl</FONT></A></TD><TD WIDTH=5>&nbsp;</TD>\n" :
                       '',
                  '<TD WIDTH=90 ALIGN=center BACKGROUND=keiltast.png><A HREF="#top">',
                      "<FONT COLOR=white>Seiten-<BR>anfang</FONT></A></TD><TD WIDTH=5>&nbsp;</TD>\n",
                  '<TD WIDTH=110 ALIGN=center BACKGROUND=keiltast.png><A HREF="', $Nachfolger{$thr}, '">',
                      "<FONT COLOR=white>N&auml;chstes<BR>Thema</FONT></A></TD><TD WIDTH=5>&nbsp;</TD>\n",
                  '<TD BGCOLOR=', $FARBE_PANEL, ">&nbsp;</TD></TR>\n",
              "</TABLE>\n",
              "</BODY>\n",
              "</HTML>\n";

    close MSG;
}

$ttl_msgs_ctr = 0;

if (@ARGV == 0) {
    print $PROGRAM, ": Dateiname(n) beim Aufruf mitgeben.\n";
}
else {
    print $PROGRAM, ': ', $DESCRPT, "\n\n";

    &LeseKonfigDatei();
    &LeseAlteDateinamen();

    @KnownGroups = ();
    &LeseGruppenliste();

    @dateien = ();
    foreach (@ARGV) {
        if (substr($_, 0, 1) eq '-') {

            m/a/ && &LeseDateiListe;

            m/c/ && ($MAX_COMMENT = 5)
                 && ($SPECMODE = 1)
#                && ($FONT_SIZE_LRG = 130)
#                && ($FONT_SIZE_MID = 110)
#                && ($FONT_SIZE_SML = 100)
                 && print("*** Ausgabemodus fuer kompakte Geraete.\n");

            m/f/ && ($LINK_TO_CHAPTERS = 0)
                 && print("*** Links zu Dateien, nicht zu Kapiteln.\n");

            m/n/ && ($DAT_NICHT_SCHREIBEN = 1);

            m/w/ && ($MAX_COMMENT = 5)
                 && ($SPECMODE = 2)
                 && print("*** Ausgabemodus in Frames fuer das Web.\n");

            m/z/ && ($RUECKBUT = 1)
                 && print("*** Mit Rueck-Button.\n");

        }
        else {
            push @dateien, $_;
        }
    }

    print("*** Ausgabemodus fuer Frames.\n") if $SPECMODE == 0;
    print "\n";

    $CSS_STYLE = '<STYLE TEXT="text/css">' . "\n" .
                 '.VerdLrg { font-family: Verdana, Arial, sans-serif; ' .
                 'font-size: ' . $FONT_SIZE_LRG . "%; }\n" .
                 '.VerdMid { font-family: Verdana, Arial, sans-serif; ' .
                 'font-size: ' . $FONT_SIZE_MID . "%; }\n" .
                 '.VerdSml { font-family: Verdana, Arial, sans-serif; ' .
                 'font-size: ' . $FONT_SIZE_SML . "%; }\n" .
                 "A:link {text-decoration: none; color: blue}\n" .
                 "A:visited {text-decoration: none; color: red}\n" .
                 "A:active {text-decoration: none: color:#FFFFFF}\n" .
                 "A:hover {text-decoration: underline}\n" .
                 "</STYLE>\n";

    foreach $file (@dateien) {

        $new_item = 1 - $OldNewsFiles{$file};

        print 'Lese ', $new_item ? '' : 'alte ', 'Datei ', $file, "...\n";
        open(IN, '<'. $file);

        $lines_in = $lines_out = 0;
        $msgs_in  = $msgs_out  = 0;
        $LineCount = 0;
        $LastLine = '';
        $Header = $Footer = 0;
        $MsgLines = 0;
        $NeedBreak = 0;
        $DroppedUnknownGroup = 0;
        $DroppedMessageLines = 0;
        $DroppedUnwantedSubj = 0;
        $DroppedDuplicateId  = 0;

        while (<IN>) {
            chomp;
            $lines_in++;

            if (m/^From - ... \w+ \d+ \d\d:\d\d:\d\d \d+/) {
                $ttl_msgs_ctr++;
                $SkipThisMessage = 0;

                $msgs_in++;
                $Header = 1;
                $Footer = 0;
                $LineCount = 0;
                $MsgId = $Reference = $Depth = $Group = $From = $Domain = $Date = $Subject = '';
                $CommentLine = 0;
                $MsgLines = 0;

                next;
            }

            next if $SkipThisMessage;

            s/=\?ISO-8859-\d+\?Q\?//ig;
            s/\?=//g;
            s/=3D/=/g;
            s/=E4/&auml;/g;
            s/=F6/&ouml;/g;
            s/=FC/&uuml;/g;
            s/=DF/&szlig;/g;
            s/=20/ /g;

            if ($Header) {
                if ($_ eq '') {

                    $MsgStore[$ttl_msgs_ctr]->{'Id'}   = $MsgId;
                    $MsgStore[$ttl_msgs_ctr]->{'From'} = $From;
                    $MsgStore[$ttl_msgs_ctr]->{'Domn'} = $Domain;
                    $MsgStore[$ttl_msgs_ctr]->{'Subj'} = $Subject;
                    $MsgStore[$ttl_msgs_ctr]->{'Date'} = $Date;
                    # $MsgStore[$ttl_msgs_ctr]->{'Grp'} = $Group;
                    $MsgStore[$ttl_msgs_ctr]->{'Len'}  = $MsgLines;
                    $MsgStore[$ttl_msgs_ctr]->{'Cnt'}  = 0;
                    $MsgStore[$ttl_msgs_ctr]->{'Ref'}  = $Reference;
                    $MsgStore[$ttl_msgs_ctr]->{'Dep'}  = $Depth;
                    $MsgStore[$ttl_msgs_ctr]->{'New'}  = $new_item;

                    # $MsgStore[$ttl_msgs_ctr]->{'VorgNr'} = 0;
                    # $MsgStore[$ttl_msgs_ctr]->{'AntwNr'} = 0;
                    # $MsgStore[$ttl_msgs_ctr]->{'LiNaNr'} = 0;
                    # $MsgStore[$ttl_msgs_ctr]->{'ReNaNr'} = 0;

                    $MsgStore[$ttl_msgs_ctr]->{'MsgBody'} = [];

                    $IdStore{$MsgId} = $ttl_msgs_ctr;

                    $MsgCount{$Group}++ if $new_item;

                    $msgs_out++;

                    if ($MsgCount{$Group} == 1) {
                        $ThreadStore{$Group} = [];
                        $ThreadMsgs{$Group} = {};
                    }

                    # Subject kanonifizieren
                    $Subject = lc $Subject;
                    $Subject =~ tr/0-9a-z //cd;
                    $Subject = substr($Subject, 0, 40);

                    push @{$$ThreadStore{$Group}}, $Subject
                        unless exists ${$$ThreadMsgs{$Group}->{$Subject}}[0];

                    push @{$$ThreadMsgs{$Group}->{$Subject}}, $ttl_msgs_ctr;

                    $NewThreads{$Group}->{$Subject}++ if $new_item;

                    $Header = 0;
                    $LastLine = '';
                    next;
                }

                if (m/^From:\s+/i) {
                    $From = $';
                    $Domain = '';

                    # Absenderangaben normalisieren in
                    #    Vorname Nachname <Domain>
                    # Keine Anfuehrungszeichen, kein Username.

                    if ($From =~ m/^"?([^"]+)"? <.+@(.+)>/) {
                        $From = $1;
                        $Domain = $2;
                    }
                    elsif ($From =~ m/@(.+) \((.+)\)$/) {
                        $From = $2;
                        $Domain = $1;
                    }
                    elsif ($From =~ m/(.+)@(.+)/) {
                        $From = $1;
                        $Domain = $2;
                    }

                    $Domain = '&lt;' . $Domain . '&gt;' unless $Domain eq '';
                }

                elsif (m/^Message-Id:\s+/i) {
                    $MsgId = $';

                    $MsgId =~ s/^<//;
                    $MsgId =~ s/>$//;

                    if (exists $IdStore{$MsgId}) {
                        $SkipThisMessage = 1;
                        $DroppedDuplicateId++;
                        print "\t-- Id doppelt: ", substr($MsgId, 0, 45), "!\n";
                    }
                }

                elsif (m/^References:\s+/i) {
                    $Reference = $';
                    my @tmplist = split(' ', $Reference);
                    $Depth = scalar @tmplist;
                    $Reference = pop @tmplist;

                    $Reference =~ s/^<//;
                    $Reference =~ s/>$//;
                }

                elsif (m/^Lines: +/i) {
                    $MsgLines = $';
                }

                elsif (m/^Newsgroups:\s+/i) {
                    $tmp = $';

                    # Schnittmenge zwischen bekannten Gruppen
                    # und angegebener Gruppenliste bilden.
                    # Default-Gruppe, falls keine Schnittmenge.

                    my %mark = ();
                    map($mark{$_}++, split(',', $tmp));
                    my @tmplist = grep($mark{$_}, @KnownGroups);

                    if (scalar @tmplist == 0) {
                        $SkipThisMessage = 1;
                        print "\t-- Gruppe unbekannt: ", $tmp, "!\n";

                        $DroppedUnknownGroup++;
                    }
                    else {
                        $Group = $tmplist[0];
                    }
                }

                elsif (m/^Date:\s+/i) {
                    ($tmp = $') =~ m/^([A-Z][a-z][a-z]. +)?(\d+) (\w\w\w) (\d+\s?\d\d:\d\d):\d\d( .\w+)?/;
                    $Date = substr(100+$2, 1, 2) . '.' . $MonNr{$3} . '.' . $4 . $5;
                }

                elsif (m/^Subject:\s+/i) {
                    $Subject = $';

                    $Subject =~ s/^re: *//i;
                    $Subject =~ s/^re: *//i;
                    $Subject =~ s/^re: *//i;
                    # Einfache Durchfuehrung mit Switch g=global funkt't nicht!!!
                    $Subject =~ s/^aw: *//i;

                    foreach $tmp (@DropSubj) {
                        $SkipThisMessage = 1 if m/$tmp/i;
                    }
                    if ($SkipThisMessage) {
                        $DroppedUnwantedSubj++;
                        print "\t-- Subjekt unerwuenscht: ", substr($Subject, 0, 45), "!\n";
                    }
                }
            }
            elsif ($new_item) {

                (m/^\s*$/) && ($LastLine eq '<BR>') && next;

#                s/\8E/&Auml;/g;
#                s/\99/&OUml;/g;
#                s/\9A/&Uuml;/g;
#                s/\84/&auml;/g;
#                s/\94/&ouml;/g;
#                s/\81/&uuml;/g;
#                s/\E1/&szlig;/g;

                if ($LineCount < 6) {
                    if ($LineCount < 3) {
                        m/^(> ?)+$/ &&         next;
                        m/says\.*$/ &&         next;
                        m/wrote:/ &&           next;
                        m/writes:/ &&          next;
                        m/schrieb:/ &&         next;
                        m/wrote in article/ && next;
                        m/wrote in message/ && next;
                        m/In article/ &&       next;
                        m/news:.*\.\.\./ &&    next;
                    }

#                   (substr(lc $_, 0, 15) eq
#                    substr(lc $Subject, 0, 15)) && next;
                }

                $tmp = 0;
                foreach $dln (@DropLines) {
                    $tmp = 1 if m/$dln/i;
                }
                ($DroppedMessageLines++ && next) if $tmp;

                s/-----+/-----/g;
                s/=====+/=====/g;
                s/#####+/#####/g;

                $p = index($_, '>');
                if ((0 <= $p) && ($p < 4) && ($Footer == 0)) {

                    if ($Group =~ m/$NO_MAX_COMMENT/) {
                        $CommentLine = 0;
                    }
                    else {
                        $CommentLine++;
                    }

                    if ($CommentLine <= $MAX_COMMENT) {
                        $_ = '<EM><FONT COLOR='.
                                        (m/^>\s*>/ ? 'red' : 'blue') .
                                        '>' . $_ . '</FONT></EM>';
                    }
                    elsif ($CommentLine == $MAX_COMMENT+1) {
                        $_ = '[... Zitat &gt; ' . $MAX_COMMENT . ' Zeilen]';
                    }
                    else {
                        next;
                    }
                }
                else {
                    $CommentLine = 0;
                }

                s/^\s+//;                            # Fuehrende Leerzeichen weg
                s/\*([ \w']+)\*/<B>$1<\/B>/g;        #
                s/ _([ A-Za-z0-9]+)_/ <U>$1<\/U>/g;  # \w enthaelt Unterstrich '_'
                s/_([ A-Za-z0-9]+)_ /<U>$1<\/U> /g;  # \w enthaelt Unterstrich '_'
                s| /(\w+)/(\W)| <I>$1</I>$2|g;       # Italics, aber keine Pfade umsetzen
                s|</?script[^>]*>||i;                # HTML-Skript-Tags entfernen

                s|^(https?://[^ ]+)$|<TABLE CLASS=VerdMid BORDER=0 CELLPADDING=3><TR BGCOLOR=${FARBE_URLNK}><TD><A HREF="$1">$1</A></TD></TR></TABLE>|;

                foreach my $cmd (@{$Cmds{substr($_, 0, 1)}}, @{$Cmds{'*'}}) {
                    if (m/$cmd/) {
                        $_ = '<TABLE CLASS=VerdSml WIDTH=100% BORDER=0 CELLSPACING=0 CELLPADDING=4>'.
                             '<TR BGCOLOR=black><TD><FONT COLOR=#00FF00>'.
                             $_ .
                             '</FONT></TD></TR></TABLE>';
                        last;
                    }
                }

                if (substr($_, 0, 1) eq '#') {
                        $_ = '<TABLE CLASS=VerdSml WIDTH=100% BORDER=0 CELLSPACING=0 CELLPADDING=4>'.
                             '<TR BGCOLOR=black><TD><FONT COLOR=#FF0000>'.
                             $_ .
                             '</FONT></TD></TR></TABLE>';
                }
                elsif (m/^-- *$/) {
                    $Footer = 1;
                }

                $_ = '<FONT COLOR=grey>' . $_ . '</FONT>' if $Footer;

                $MsgStore[$ttl_msgs_ctr]->{'Cnt'} = ++$LineCount;

                $_ = '<BR>' if (($_ eq '') && !$NeedBreak);

                $NeedBreak = (length($_) < $LONG_LINE) ||
                             (substr($_, 0, 4) eq '<EM>') ||
                             (substr($_, 0, 2) eq '- ') ||
                             ($_ eq '--');

                $_ .= '<BR>' if $NeedBreak;

                push @{$$MsgStore[$ttl_msgs_ctr]->{'MsgBody'}}, $_;

                $lines_out++;
                $LastLine = $_;
            }
        }

        close(IN);

        printf "\t%5d Mitteilungen mit %6d Zeilen mit Daten gelesen.\n", $msgs_in, $lines_in;
        printf "\t%5d Mitteilungen mit %6d Textzeilen gespeichert.\n", $msgs_out, $lines_out;

        printf "\t%5d Mitteilungen wg doppelter ID verworfen.\n", $DroppedDuplicateId
            if $DroppedDuplicateId;

        printf "\t%5d Mitteilungen wg unbekannter Gruppe verworfen.\n", $DroppedUnknownGroup
            if $DroppedUnknownGroup;

        printf "\t%5d Mitteilungen wg unerwuenschtem Betreff verworfen.\n", $DroppedUnwantedSubj
            if $DroppedUnwantedSubj;

        printf "\t%5d Zeilen wg Unerheblichkeit entfernt.\n", $DroppedMessageLines
            if $DroppedMessageLines;

        print  "\n";
    }

    &StoreIndexFile();
    &SchreibeAlteDateinamen() unless $DAT_NICHT_SCHREIBEN;

    $gc = 0;
    foreach $Group (sort keys %MsgCount) {
        $gc++;
        &StoreGroupFile($Group, $gc);

        %Nachfolger = ();
        my $ltr = '-';
        foreach $Thread (@{$$ThreadStore{$Group}}) {

            @msgs = @{$$ThreadMsgs{$Group}->{$Thread}};
            $Nachfolger{$ltr} = $THREAD_PREFIX . &frmint($msgs[0], 4) . $FILE_EXT;

# print 'Msg: ', $msgs[0], "\tThema: ", $Thread, "\n";

            $ltr = $Thread;
        }
        $Nachfolger{$ltr} = $GROUP_PREFIX . '000' . $FILE_EXT;

        foreach $Thread (keys %{$NewThreads{$Group}}) {
            &StoreThreadFile($Thread, $Group, $gc);
        }
    }

    print "\nInsgesamt\t\t", $ttl_msgs_ctr, " Mitteilungen verarbeitet. Fertig.\n";
}
